# -*- coding: utf-8 -*-

# Copyright (c) 2016 - 2022 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the QtHelp documentation provider plug-in.
"""

import os
import glob

from PyQt6.QtCore import QObject

# Start-Of-Header
name = "Documentation Sets"
author = "Detlev Offenbach <detlev@die-offenbachs.de>"
autoactivate = True
deactivateable = True
version = "10.0.0"
className = "PluginDocumentationSets"
packageName = "DocumentationSets"
shortDescription = "Documentation sets in QtHelp format (*.qch)"
longDescription = (
    """This plug-in provides an interface to additional documentation sets"""
    """ in QtHelp format (*.qch) for registration with the eric help/web"""
    """ browser or Qt Assistant."""
)
needsRestart = False
pyqtApi = 2
# End-Of-Header

error = ""


def helpFiles():
    """
    Module function to return the documentation sets provided by this plug-in.
    
    @return dictionary with documentation set type as key and list of
        documentation files as values
    @rtype dict (key: str, value: list of str)
    """
    documentationSets = {}
    documentationSetsDir = os.path.join(os.path.dirname(__file__),
                                        "DocumentationSets")
    if os.path.isdir(documentationSetsDir):
        documentationTypes = [
            d for d in os.listdir(documentationSetsDir)
            if os.path.isdir(os.path.join(documentationSetsDir, d))
        ]
        for documentationType in documentationTypes:
            documentationSets[documentationType] = glob.glob(
                os.path.join(documentationSetsDir, documentationType, "*.qch"))
    
    return documentationSets


class PluginDocumentationSets(QObject):
    """
    Class implementing the QtHelp documentation provider plug-in.
    """
    def __init__(self, ui):
        """
        Constructor
        
        @param ui reference to the user interface object (UI.UserInterface)
        """
        super().__init__(ui)
        self.__ui = ui
    
    def activate(self):
        """
        Public method to activate this plugin.
        
        @return tuple of None and activation status (boolean)
        """
        global error
        error = ""     # clear previous error
        
        return None, True
    
    def deactivate(self):
        """
        Public method to deactivate this plugin.
        """
        pass
